/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.DrawerInfoGuiAddon;
import com.buuz135.functionalstorage.inventory.CompactingInventoryHandler;
import com.buuz135.functionalstorage.util.CompactingUtil;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SimpleCompactingDrawerTile
extends ItemControllableDrawerTile<SimpleCompactingDrawerTile> {
    private final LazyOptional<IItemHandler> lazyStorage;
    @Save
    public CompactingInventoryHandler handler = new CompactingInventoryHandler(2){

        @Override
        public void onChange() {
            SimpleCompactingDrawerTile.this.markForUpdate();
        }

        @Override
        public int getMultiplier() {
            return SimpleCompactingDrawerTile.this.getStorageMultiplier();
        }

        @Override
        public boolean isVoid() {
            return SimpleCompactingDrawerTile.this.isVoid();
        }

        @Override
        public boolean hasDowngrade() {
            return SimpleCompactingDrawerTile.this.hasDowngrade();
        }

        @Override
        public boolean isCreative() {
            return SimpleCompactingDrawerTile.this.isCreative();
        }

        @Override
        public boolean isLocked() {
            return SimpleCompactingDrawerTile.this.isLocked();
        }
    };
    private boolean hasCheckedRecipes = false;

    public SimpleCompactingDrawerTile(BasicTileBlock<SimpleCompactingDrawerTile> base, BlockEntityType<SimpleCompactingDrawerTile> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.lazyStorage = LazyOptional.of(() -> this.handler);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DrawerInfoGuiAddon(64, 16, new ResourceLocation("functionalstorage", "textures/blocks/simple_compacting_drawer_front.png"), 2, integer -> {
            if (integer == 0) {
                return Pair.of((Object)16, (Object)28);
            }
            if (integer == 1) {
                return Pair.of((Object)16, (Object)4);
            }
            return Pair.of((Object)16, (Object)4);
        }, integer -> this.getStorage().getStackInSlot(integer.intValue()), integer -> this.getStorage().getSlotLimit(integer.intValue())));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, SimpleCompactingDrawerTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (!this.hasCheckedRecipes) {
            if (!this.handler.getParent().m_41619_()) {
                CompactingUtil compactingUtil = new CompactingUtil(this.f_58857_, 2);
                compactingUtil.setup(this.handler.getParent());
                this.handler.setup(compactingUtil);
            }
            this.hasCheckedRecipes = true;
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (!this.handler.isSetup() && slot != -1) {
            stack = playerIn.m_21120_(hand).m_41777_();
            stack.m_41764_(1);
            CompactingUtil compactingUtil = new CompactingUtil(this.f_58857_, 2);
            compactingUtil.setup(stack);
            this.handler.setup(compactingUtil);
            for (int i = 0; i < this.handler.getResultList().size(); ++i) {
                if (!ItemStack.m_41746_((ItemStack)this.handler.getResultList().get(i).getResult(), (ItemStack)stack)) continue;
                slot = i;
                break;
            }
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @Override
    public int getStorageSlotAmount() {
        return 3;
    }

    @Override
    public IItemHandler getStorage() {
        return this.handler;
    }

    @Override
    public LazyOptional<IItemHandler> getOptional() {
        return this.lazyStorage;
    }

    @Override
    public int getBaseSize(int slot) {
        return this.handler.getSlotLimitBase(slot);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public SimpleCompactingDrawerTile getSelf() {
        return this;
    }

    public CompactingInventoryHandler getHandler() {
        return this.handler;
    }
}

